<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    * 
    * gli elementi del portfolio vengono salvati nella tabella contenuti, quindi questa classe estende la classe Contenuto che descrive
    * i contenuti in Geecom
    */

    class ElementoPortfolio extends Contenuto {
        
        public function __construct($db,$id,$contenutoRiferimento = 0,$lingua = "",$tipo = "", $posizione = 0, $mostraNellaHome = "",$stato = "",$punteggioSeo = "",$template = "",$attivaBreadcrumbs = "",$tipoVisualizzazione = "",$titolo = "",$descrizione="", $metaDescrizione = "", $testo="", $foto = "", $autore="",$dataCreazione = "",$dataPubblicazione = "") {
            parent::__construct($db, $id, $contenutoRiferimento, $lingua, $tipo, $posizione, $mostraNellaHome, $stato, $punteggioSeo, $template, $attivaBreadcrumbs, $tipoVisualizzazione, $titolo, $descrizione, $metaDescrizione, $testo, $foto, $autore, $dataCreazione);
        }

        function stampaImmaginiElemento() {
            $query = "SELECT * FROM geec_immagini WHERE tipoImmagine LIKE 'immagineElementoPortfolio' AND idContenuto=".parent::getId()." ORDER BY posizione ASC";
            $risultatoQuery = parent::getDb()->eseguiQueryLettura($query);
            while($immagine = $risultatoQuery->fetch_assoc()) {
                $posizionePrecedente = $immagine["posizione"]-1;
                $posizioneSuccessiva = $immagine["posizione"]+1;
            ?>
                <div id="immagineContenuto<?php echo $immagine["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center">
                    <div class="immagineAssociataContenuto d-flex w-100">
                        <div class="background-image" style="background: url(../../../<?php echo $immagine["percorso"] ?>)"></div>
                        <div class="input-group input-group-sm mr-3 align-self-center">
                            <input type="text" id="didascaliaImmagine<?php echo $immagine["id"] ?>" class="form-control" value="<?php echo $immagine["descrizione"] ?>" placeholder="Diascalia" aria-label="Didascalia" aria-describedby="didascalia">
                            <div class="input-group-append">
                                <button type="button" class="btn btn-primary" onclick="modificaDidascaliaImmagine('../../../',<?php echo $immagine["id"] ?>)">Salva</button>
                            </div>
                        </div>
                    </div>
                    <div class="azioni d-flex align-items-center justify-content-end">
                        <form class="d-inline-flex mr-sm-1">
                            <div class="input-group input-group-sm d-flex align-items-center">
                                <small class="text-muted mr-2">Pos.</small>
                                <input type="number" id="posizioneImmagineContenuto<?php echo $immagine["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $immagine["posizione"] ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="button" onclick="modificaPosizioneImmagineContenutoDaInput('../../../',<?php echo parent::getId(); ?>,<?php echo $immagine["id"]; ?>)">Salva</button>
                                </div>
                            </div>
                        </form>
                        <div class="btn-group" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaPosizioneImmagineContenuto('../../../',<?php echo parent::getId(); ?>,<?php echo $immagine["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaPosizioneImmagineContenuto('../../../',<?php echo parent::getId(); ?>,<?php echo $immagine["id"]; ?>,<?php echo $posizioneSuccessiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="rendiImmagineInEvidenzaContenuto('../../../',<?php echo parent::getId(); ?>,'<?php echo $immagine["percorso"]; ?>');" data-original-title="Metti in evidenza"><i class="far fa-image"></i></button>
                            <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaOccorrenzaImmagine('../../../',<?php echo $immagine["id"]; ?>,'<?php echo $immagine["percorso"]; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function spostaInAltroPortfolio($idPortfolio) {
            $queryUltimaPosizione = "SELECT posizione FROM geecB_contenuti WHERE contenutoRiferimento=$idPortfolio ORDER BY posizione DESC LIMIT 1";
            $resultPosizione      = parent::getDb()->eseguiQueryLettura($queryUltimaPosizione);
            if($resultPosizione->num_rows==0) { //la tabella è vuota
                $nuovaPosizione=1;
            }
            else {
                $risPosizione = $resultPosizione->fetch_array(MYSQLI_NUM);
                $nuovaPosizione = $risPosizione[0]+1;
            }
            
            $query = "UPDATE geecB_contenuti SET contenutoRiferimento = $idPortfolio, posizione=$nuovaPosizione WHERE id = ".parent::getId();
            parent::getDb()->eseguiQueryScrittura($query);
        }
        
        function duplicaInAltroPortfolio($idPortfolio) {
            $idElementoDuplicato = parent::duplica("Copia di","","elementoPortfolio");
            
            $query = "UPDATE geecB_contenuti SET contenutoRiferimento = $idPortfolio WHERE id = $idElementoDuplicato";
            parent::getDb()->eseguiQueryScrittura($query);
            
            return $idElementoDuplicato;
        }
    }